var LENGTH_START = 3, // Number of intermediate symbols
    LENGTH_STEP = 3,
    DURATION_START = 0.8,
    DURATION_STEP = 0.5,
    RESULT_DELAY = 0.2,
    RESULT_STEP = 0.3;

// Returns css property prefix or false if transition is not supported.
// Note! This may return empty string if transition is supported without
// prefixes. Use '===' operator to compare the returned value with false.
function checkAnimation(elm){
    if (this.checked) {
        return this.keyframeprefix;
    }

    // This origin code is here: https://developer.mozilla.org/en/CSS/CSS_animations/Detecting_CSS_animation_support
    var keyframeprefix = false,
        domPrefixes = ['', 'Webkit', 'Moz', 'O', 'ms', 'Khtml'];

    for (var i = 0; i < domPrefixes.length; i++) {
        if (elm.style[domPrefixes[i] + 'Transition'] !== undefined) {
            var pfx = domPrefixes[i];
            keyframeprefix = pfx.toLowerCase();
            break;
        }
    }
    if (keyframeprefix) {
        keyframeprefix = '-' + keyframeprefix + '-';
    }

    this.keyframeprefix = keyframeprefix
    this.checked = true
    document.cookie = 'animation=1';

    return keyframeprefix
}

function prepareAnimation(slot_model, resolution, reels, rows){
    var pfx = checkAnimation(document.body);
    if (pfx === false) return;

    // Set the initial state for animation.
    document.body.className += ' animation begin-animation';

    // Generate styles for slot animation.

    var symbol_height = {
        'fc_classic-240': 44,
        'fc_classic-320': 55,
        'fc_modern-240': 44,
        'fc_modern-320': 65,
        'crazy_monkey-240': 47,
        'crazy_monkey-320': 59,
        'garage-240': 47,
        'garage-320': 59,
        'resident-240': 47,
        'resident-320': 59
    }[slot_model + '-' + resolution]

    // Some part of this styles is hardcoded in slot.css files.
    // TODO: move this script to scss.
    var d = document
    d.write('<style type="text/css">')
    for (var i = 0; i < reels; i++) {
        var rndPos = Math.floor(Math.random() * (8)); // Random number in [0-8]
        d.write('.column' + (i + 1) + ' .reel {background-position: 0 ' + (rndPos * symbol_height) + 'px;} ');
        d.write('.animation #matrix .column' + (i + 1) + ' .reel {height: ' + ((LENGTH_START + LENGTH_STEP * i) * symbol_height) + 'px;} ');
        d.write('.begin-animation #matrix .column' + (i + 1) + ' {' + pfx + 'transform: translate(0, -' + ((LENGTH_START + rows + LENGTH_STEP * i) * symbol_height) + 'px);} ');
        d.write('.end-animation #matrix .column' + (i + 1) + ' {' + pfx + 'transition-duration: ' + (DURATION_START + DURATION_STEP * i) + 's;} ');
    }
    d.write('</style>')
}

function startAnimation(lines, reels){
    if (checkAnimation(document.body) === false) return;

    document.body.className = document.body.className.replace(/begin-animation/, 'end-animation');

    // Show result with delay.
    var duration = DURATION_START + DURATION_STEP * (reels - 1) + RESULT_DELAY;
    window.setTimeout('document.body.className += \' end-animation0\'', duration * 1000)
    for (var i = 1; i <= lines; i++) {
        window.setTimeout('document.body.className += \' line' + i + '\'', duration * 1000)
        duration += RESULT_STEP;
    }
    window.setTimeout('document.body.className += \' animation-final\'', duration * 1000)
}


// Sprite animation.
function animate(id, className, intervals, bgPosY, startFrame) {
    var element = document.getElementById(id);
    if (!element) {
      return;
    }
    // Reset previous animation if exists.
    stopAnimation(element);
    element.className += ' ' + className;
    var frameCount = intervals.length;
    if (startFrame == undefined) {
        startFrame = 0;
    }
    if (bgPosY == undefined) {
        bgPosY = 'center'
    }
    var currentFrame = startFrame;
    function animateMonkey() {
        element.style.backgroundPosition = -currentFrame * element.clientWidth + 'px ' + bgPosY;
        element.animationTimeout = window.setTimeout(animateMonkey, intervals[currentFrame]);
        currentFrame = currentFrame >= frameCount - 1 ? 0 : currentFrame + 1;
    }
    element.animationTimeout = window.setTimeout(animateMonkey, 0);
}

function stopAnimation(element) {
    if (element.animationTimeout) {
        window.clearTimeout(element.animationTimeout);
        element.style.backgroundPosition = '';
    }
}


// Select cell.
function choiceCell(num, href) {
    var element = document.getElementById('monkey');
    // Reset previous animation.
    element.className = element.className.replace(/ ?(win|lose)/g, '');
    // Disable buttons.
    document.body.className += ' animation';
    // Stop animation for the period while the monkey is sliding to
    // selected rope.
    stopAnimation(element);
    // Run animation on timeout to allow browser refreshing the image.
    window.setTimeout(
        function () {
            // Walk to the selected cell.
            var cells = document.getElementById('cells')
            cells.className += ' choice' + num;
            element.className += ' walk';
            // delay = 0.5s. See #monkey.pull static/slot styles.
            window.setTimeout(
                function () {
                    // Hide static rope.
                    cells.className += ' .hide_rope';
                    // Pull the rope.
                    animate('monkey', 'pull', [300, 700], 'bottom');
                    // Redirect to the action url with a delay for animation.
                    setTimeout(function(){window.location = href}, 400);
                },
                500);
        },
        50); // Small delay just for refresh. Why 50? Just because it is small enough.
}

// Show result.
function animateResult(intervals) {
    animate('monkey', '', intervals, 'bottom', 1);
}

